Tiled_LF_Shape_Ellipse = Core.class(Sprite)

function Tiled_LF_Shape_Ellipse:init(xworld, xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.steps = xparams.steps or 32 -- 24
	params.rotation = xparams.rotation or 0
	params.type = xparams.type or nil -- default (nil) = b2.STATIC_BODY
	params.fixedrotation = xparams.fixedrotation or (xparams.fixedrotation == nil) -- default to true
	params.density = xparams.density or 0
	params.restitution = xparams.restitution or nil
	params.friction = xparams.friction or nil
	params.gravityscale = xparams.gravityscale or 1
	params.BIT = xparams.BIT or nil
	params.COLBIT = xparams.COLBIT or nil
	params.ROLE = xparams.ROLE or nil
	params.data = xparams.data or nil
	-- the others
	self.x = params.x
	self.y = params.y
--	self.w = params.w
--	self.h = params.h
--	self.rotation = params.rotation
--	self.BIT = params.BIT
--	self.COLBIT = params.COLBIT
	-- body, b2.STATIC_BODY, b2.KINEMATIC_BODY, b2.DYNAMIC_BODY
	self.body = xworld:createBody { type = params.type }
	self.body:setGravityScale(params.gravityscale)
	self.body.role = params.ROLE
	self.body.isdirty = false
	self.body:setFixedRotation(params.fixedrotation)
	self.body:setAngle(^<params.rotation)
	self.body:setPosition(self.x, self.y)
--	self.body.img = self.img
	self.body.data = params.data
	-- the shape
	local shape
	local sin, cos = math.sin, math.cos
	if params.w ~= params.h then -- oval
		local cs = {}
		for i = 0, 360, 360 / params.steps  do
			cs[#cs + 1] = (params.w / 2) + params.w / 2 * cos(^<i)
			cs[#cs + 1] = (params.h / 2) + params.h / 2 * sin(^<i)
		end
		shape = b2.ChainShape.new()
		shape:createLoop(unpack(cs))
	else -- circle
		local hypo = params.w/2 + params.h/2
		shape = b2.CircleShape.new(hypo/2, hypo/2, params.w/2) -- (centerx, centery, radius)
	end
	-- fixture
	local fixture = self.body:createFixture {
		shape=shape, density=params.density, restitution=params.restitution, friction=params.friction,
	}
	-- filter data
	if params.BIT == G_BITSENSOR then fixture:setSensor(true) end
	local filterData = { categoryBits=params.BIT, maskBits=params.COLBIT, groupIndex=0, }
	fixture:setFilterData(filterData)
	-- clean up?
	filterData = {} -- nil
	fixture = nil
	shape = nil
end

Tiled_LF_Shape_Point = Core.class(Sprite)

function Tiled_LF_Shape_Point:init(xworld, xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.rotation = xparams.rotation or 0
	params.type = xparams.type or nil -- default (nil) = b2.STATIC_BODY
	params.fixedrotation = xparams.fixedrotation or (xparams.fixedrotation == nil) -- default to true
	params.density = xparams.density or nil
	params.restitution = xparams.restitution or nil
	params.friction = xparams.friction or nil
	params.gravityscale = xparams.gravityscale or 1
	params.BIT = xparams.BIT or nil
	params.COLBIT = xparams.COLBIT or nil
	params.ROLE = xparams.ROLE or nil
	params.data = xparams.data or nil
	-- the others
	self.x = params.x
	self.y = params.y
--	self.w = params.w
--	self.h = params.h
--	self.rotation = params.rotation
--	self.BIT = params.BIT
--	self.COLBIT = params.COLBIT
	-- body, b2.STATIC_BODY, b2.KINEMATIC_BODY, b2.DYNAMIC_BODY
	self.body = xworld:createBody { type=params.type }
	self.body:setGravityScale(params.gravityscale)
	self.body.role = params.ROLE
	self.body.isdirty = false
	self.body:setFixedRotation(params.fixedrotation)
	self.body:setAngle(^<params.rotation)
	self.body:setPosition(self.x, self.y)
--	self.body.img = self.img
	self.body.data = params.data
	-- the shape
	local hypo = 1
	local shape = b2.CircleShape.new(hypo/2, hypo/2, hypo) -- (centerx, centery, radius)
	-- the fixture
	local fixture = self.body:createFixture {
		shape=shape, density=params.density, restitution=params.restitution, friction=params.friction,
	}
	-- filter data
	if params.BIT == G_BITSENSOR then fixture:setSensor(true) end
	local filterData = { categoryBits=params.BIT, maskBits=params.COLBIT, groupIndex=0, }
	fixture:setFilterData(filterData)
	-- clean up?
	filterData = {} -- nil
	fixture = nil
	shape = nil
end

Tiled_LF_Shape_Polygon = Core.class(Sprite)

function Tiled_LF_Shape_Polygon:init(xworld, xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.coords = xparams.coords or nil
	params.rotation = xparams.rotation or 0
	params.type = xparams.type or nil -- default (nil) = b2.STATIC_BODY
	params.fixedrotation = xparams.fixedrotation or (xparams.fixedrotation == nil) -- default to true
	params.density = xparams.density or nil
	params.restitution = xparams.restitution or nil
	params.friction = xparams.friction or nil
	params.gravityscale = xparams.gravityscale or 1
	params.BIT = xparams.BIT or nil
	params.COLBIT = xparams.COLBIT or nil
	params.ROLE = xparams.ROLE or nil
	params.data = xparams.data or nil
	-- the others
	self.x = params.x
	self.y = params.y
--	self.w = params.w
--	self.h = params.h
--	self.rotation = params.rotation
--	self.BIT = params.BIT
--	self.COLBIT = params.COLBIT
	-- body, b2.STATIC_BODY, b2.KINEMATIC_BODY, b2.DYNAMIC_BODY
	self.body = xworld:createBody { type=params.type }
	self.body:setGravityScale(params.gravityscale)
	self.body.role = params.ROLE
	self.body.isdirty = false
	self.body:setFixedRotation(params.fixedrotation)
	self.body:setAngle(^<params.rotation)
	self.body:setPosition(self.x, self.y)
--	self.body.img = self.img
	self.body.data = params.data
	-- the shape
	local shape
	local cs = {}
	for c = 1, #params.coords do
		cs[#cs+1] = params.coords[c].x
		cs[#cs+1] = params.coords[c].y
	end
	if #params.coords == 2 then -- this is a line
		shape = b2.EdgeShape.new(cs[1], cs[2], cs[3], cs[4])
	else -- this is a polygon
		shape = b2.ChainShape.new()
		shape:createLoop(unpack(cs))
	end
	-- the fixture
	local fixture = self.body:createFixture {
		shape=shape, density=params.density, restitution=params.restitution, friction=params.friction,
	}
	-- filter data
	if params.BIT == G_BITSENSOR then fixture:setSensor(true) end
	local filterData = { categoryBits=params.BIT, maskBits=params.COLBIT, groupIndex=0, }
	fixture:setFilterData(filterData)
	-- clean up?
	filterData = {} -- nil
	fixture = nil
	cs = {} -- nil
	shape = nil
end

Tiled_LF_Shape_Polyline = Core.class(Sprite)

function Tiled_LF_Shape_Polyline:init(xworld, xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.coords = xparams.coords or nil
	params.rotation = xparams.rotation or 0
	params.type = xparams.type or nil -- default (nil) = b2.STATIC_BODY
	params.fixedrotation = xparams.fixedrotation or (xparams.fixedrotation == nil) -- default to true
	params.density = xparams.density or nil
	params.restitution = xparams.restitution or nil
	params.friction = xparams.friction or nil
	params.gravityscale = xparams.gravityscale or 1
	params.BIT = xparams.BIT or nil
	params.COLBIT = xparams.COLBIT or nil
	params.ROLE = xparams.ROLE or nil
	params.data = xparams.data or nil
	-- the others
	self.x = params.x
	self.y = params.y
--	self.w = params.w
--	self.h = params.h
--	self.rotation = params.rotation
--	self.BIT = params.BIT
--	self.COLBIT = params.COLBIT
	-- body, b2.STATIC_BODY, b2.KINEMATIC_BODY, b2.DYNAMIC_BODY
	self.body = xworld:createBody { type=params.type }
	self.body:setGravityScale(params.gravityscale)
	self.body.role = params.ROLE
	self.body.isdirty = false
	self.body:setFixedRotation(params.fixedrotation)
	self.body:setAngle(^<params.rotation)
	self.body:setPosition(self.x, self.y)
--	self.body.img = self.img
	self.body.data = params.data
	-- the shape
	local shape
	local cs = {}
	for c = 1, #params.coords do
		cs[#cs+1] = params.coords[c].x
		cs[#cs+1] = params.coords[c].y
	end
	if #params.coords == 2 then -- this is a line
		shape = b2.EdgeShape.new(cs[1], cs[2], cs[3], cs[4])
	else -- this is a polyline
		shape = b2.ChainShape.new()
		shape:createChain(unpack(cs))
	end
	-- the fixture
	local fixture = self.body:createFixture {
		shape=shape, density=params.density, restitution=params.restitution, friction=params.friction,
	}
	-- filter data
	if params.BIT == G_BITSENSOR then fixture:setSensor(true) end
	local filterData = { categoryBits=params.BIT, maskBits=params.COLBIT, groupIndex=0, }
	fixture:setFilterData(filterData)
	-- clean up?
	filterData = {} -- nil
	fixture = nil
	cs = {} -- nil
	shape = nil
end

Tiled_LF_Shape_Rectangle = Core.class(Sprite)

function Tiled_LF_Shape_Rectangle:init(xworld, xparams)
	-- params
	local params = xparams or {}
	params.x = xparams.x or nil
	params.y = xparams.y or nil
	params.w = xparams.w or nil
	params.h = xparams.h or nil
	params.rotation = xparams.rotation or 0
	params.type = xparams.type or nil -- default (nil) = b2.STATIC_BODY
	params.fixedrotation = xparams.fixedrotation or (xparams.fixedrotation == nil) -- default to true
	params.density = xparams.density or nil
	params.restitution = xparams.restitution or nil
	params.friction = xparams.friction or nil
	params.gravityscale = xparams.gravityscale or 1
	params.BIT = xparams.BIT or nil
	params.COLBIT = xparams.COLBIT or nil
	params.ROLE = xparams.ROLE or nil
	params.data = xparams.data or nil
	-- the others
	self.x = params.x
	self.y = params.y
--	self.w = params.w
--	self.h = params.h
--	self.rotation = params.rotation
--	self.BIT = params.BIT
--	self.COLBIT = params.COLBIT
	-- body, b2.STATIC_BODY, b2.KINEMATIC_BODY, b2.DYNAMIC_BODY
	self.body = xworld:createBody { type=params.type }
	self.body:setGravityScale(params.gravityscale)
	self.body.role = params.ROLE
	self.body.isdirty = false
	self.body:setFixedRotation(params.fixedrotation)
	self.body:setAngle(^<params.rotation)
	self.body:setPosition(self.x, self.y)
--	self.body.img = self.img
	self.body.data = params.data
	-- the shape
	local shape = b2.PolygonShape.new()
	shape:setAsBox(
		params.w/2, params.h/2, -- half w, half h
		params.w/2, params.h/2, -- centerx, centery
		0) -- rotation
	-- the fixture
	local fixture = self.body:createFixture {
		shape=shape, density=params.density, restitution=params.restitution, friction=params.friction,
	}
	-- filter data
	if params.BIT == G_BITSENSOR then fixture:setSensor(true) end
	local filterData = { categoryBits=params.BIT, maskBits=params.COLBIT, groupIndex=0, }
	fixture:setFilterData(filterData)
	-- clean up?
	filterData = {} -- nil
	fixture = nil
	shape = nil
end
