LevelX = Core.class(Sprite)

function LevelX:init()
	application:setBackgroundColor(0x5500ff)
	-- _____  _     _    _  _____ _____ _   _  _____ 
	--|  __ \| |   | |  | |/ ____|_   _| \ | |/ ____|
	--| |__) | |   | |  | | |  __  | | |  \| | (___  
	--|  ___/| |   | |  | | | |_ | | | | . ` |\___ \ 
	--| |    | |___| |__| | |__| |_| |_| |\  |____) |
	--|_|    |______\____/ \_____|_____|_| \_|_____/ 
	-- tiny-ecs
	self.tiny = require "classes/tiny-ecs"
	self.tiny.tworld = self.tiny.world()
	-- liquidfun
	local bworld = b2.World.new(0, 20, true) -- gravity x, gravity y, doSleep?
	-- _           __     ________ _____   _____ 
	--| |        /\\ \   / /  ____|  __ \ / ____|
	--| |       /  \\ \_/ /| |__  | |__) | (___  
	--| |      / /\ \\   / |  __| |  _  / \___ \ 
	--| |____ / ____ \| |  | |____| | \ \ ____) |
	--|______/_/    \_\_|  |______|_|  \_\_____/ 
	local layers = {}
	layers["main"] = Sprite.new() -- one Sprite to hold them all
	layers["bg"] = Sprite.new() -- bg layer
	layers["actors"] = Sprite.new() -- actors layer
	layers["fg"] = Sprite.new() -- fg layer
	layers["player1input"] = Sprite.new() -- player1 input layer
	-- _      ________      ________ _       _____ 
	--| |    |  ____\ \    / /  ____| |     / ____|
	--| |    | |__   \ \  / /| |__  | |    | (___  
	--| |    |  __|   \ \/ / |  __| | |     \___ \ 
	--| |____| |____   \  /  | |____| |____ ____) |
	--|______|______|   \/   |______|______|_____/ 
	self.tiledlevels = {}
	self.tiledlevels[1] = "tiled/levels/level01" -- lua file without extension
	self.tiledlevels[2] = "tiled/levels/level02" -- lua file without extension
	-- ...
	-- here we build the level using Tiled
	local currlevel = TiledLevels.new(self.tiledlevels[g_currlevel], self.tiny, bworld, layers)
	-- _____  _           __     ________ _____  __ 
	--|  __ \| |        /\\ \   / /  ____|  __ \/_ |
	--| |__) | |       /  \\ \_/ /| |__  | |__) || |
	--|  ___/| |      / /\ \\   / |  __| |  _  / | |
	--| |    | |____ / ____ \| |  | |____| | \ \ | |
	--|_|    |______/_/    \_\_|  |______|_|  \_\|_|
	self.player1 = currlevel.player1
	--  _____          __  __ ______ _____            
	-- / ____|   /\   |  \/  |  ____|  __ \     /\    
	--| |       /  \  | \  / | |__  | |__) |   /  \   
	--| |      / /\ \ | |\/| |  __| |  _  /   / /\ \  
	--| |____ / ____ \| |  | | |____| | \ \  / ____ \ 
	-- \_____/_/    \_\_|  |_|______|_|  \_\/_/    \_\
	local zoom = 1.5 -- 1.7
	self.camera = Sprite.new()
	self.camera:setScale(zoom)
	--  ____  _____  _____  ______ _____  
	-- / __ \|  __ \|  __ \|  ____|  __ \ 
	--| |  | | |__) | |  | | |__  | |__) |
	--| |  | |  _  /| |  | |  __| |  _  / 
	--| |__| | | \ \| |__| | |____| | \ \ 
	-- \____/|_|  \_\_____/|______|_|  \_\
	layers["main"]:addChild(layers["bg"])
	layers["main"]:addChild(layers["actors"])
	layers["main"]:addChild(layers["fg"])
	self.camera:addChild(layers["main"])
	self:addChild(self.camera)
	self:addChild(layers["player1input"])
	--  _______     _______ _______ ______ __  __  _____ 
	-- / ____\ \   / / ____|__   __|  ____|  \/  |/ ____|
	--| (___  \ \_/ / (___    | |  | |__  | \  / | (___  
	-- \___ \  \   / \___ \   | |  |  __| | |\/| |\___ \ 
	-- ____) |  | |  ____) |  | |  | |____| |  | |____) |
	--|_____/   |_| |_____/   |_|  |______|_|  |_|_____/ 
	self.tiny.tworld:add(
		SDrawable.new(self.tiny),
		SPlayer1.new(self.tiny),
		SCollision.new(self.tiny, bworld, self.player1),
		SPlayer1Control.new(self.tiny, self.camera, mapdef, player1inputlayer)
	)
	-- _      ______ _______ _  _____    _____  ____  _ 
	--| |    |  ____|__   __( )/ ____|  / ____|/ __ \| |
	--| |    | |__     | |  |/| (___   | |  __| |  | | |
	--| |    |  __|    | |     \___ \  | | |_ | |  | | |
	--| |____| |____   | |     ____) | | |__| | |__| |_|
	--|______|______|  |_|    |_____/   \_____|\____/(_)
	self.world = bworld
	-- debug draw
	local showdebug = false -- true, false
	if showdebug then
		local debugDraw = b2.DebugDraw.new()
		debugDraw:setFlags(b2.DebugDraw.SHAPE_BIT)
		self.world:setDebugDraw(debugDraw)
		layers["main"]:addChild(debugDraw)
	end
	-- listeners
	self:addEventListener(Event.ENTER_FRAME, self.onEnterFrame, self) -- the game loop
	self:myKeysPressed() -- keys handler
end

-- game loop
function LevelX:onEnterFrame(e)
	local dt = e.deltaTime
	-- camera
	local posx, posy = self.player1.lf.body:getPosition()
	self.camera:set("anchorX", posx-myappwidth/2/self.camera:getScale())
	self.camera:set("anchorY", posy-myappheight/1.8/self.camera:getScale())
	-- liquidfun
	self.world:step(dt, 8, 3) -- e.deltaTime 1/60, 8, 3
	-- tiny ecs (last?)
	self.tiny.tworld:update(dt)
end

-- keys handler
function LevelX:myKeysPressed()
	self:addEventListener(Event.KEY_DOWN, function(e) -- KEY_UP
		-- exit
		if e.keyCode == KeyCode.ESC or e.keyCode == KeyCode.BACK then
			if not application:isPlayerMode() then application:exit() end
		end
		-- full screen
		local modifier = application:getKeyboardModifiers()
		local alt = (modifier & KeyCode.MODIFIER_ALT) > 0
		if (not alt and e.keyCode == KeyCode.ENTER) then -- nothing here!
		elseif alt and e.keyCode == KeyCode.ENTER then -- SWITCH FULLSCREEN
			ismyappfullscreen = not ismyappfullscreen
			application:setFullScreen(ismyappfullscreen)
		end
	end)
end
