EPlayer1 = Core.class()

function EPlayer1:init(xworld, xspritelayer, xpos)
	self.isplayer1 = true
	self.spritelayer = xspritelayer
	-- params
	self.pos = xpos
	self.sx = 1
	self.sy = self.sx
	self.flip = 1
	-- the sprite
	self.sprite = Pixel.new(0xff0000, 1, 32, 64)
	self.sprite:setAnchorPoint(0.5, 0.5)
	self.sprite:setScale(self.sx, self.sy)
	self.w, self.h = self.sprite:getWidth()//1, self.sprite:getHeight()//1 -- with applied scale
	-- COMPONENTS*
	local collw, _collh = (self.w*0.15)//1, (self.h*0.85)//1
	-- *BODY: CBody:init(xmass, xspeed, xupspeed)
	self.body = CBody.new(1, 36*8, 0.13*8)
	-- *LIQUIDFUN: CLiquidfun:init(xworld) -- table
	self.lf = CLiquidfun.new( { world=xworld, role=G_PLAYER, } )
	self.lf.body:setPosition(self.pos.x, self.pos.y)
	local shape = b2.CircleShape.new(0, self.h/2-collw, collw) -- (centerx, centery, radius)
	local fixture = self.lf.body:createFixture {
		shape=shape, density=1, restitution=0, friction=0, -- 1
	}
	local filterData = {
		categoryBits=G_BITPLAYER, maskBits=playercollisions, groupIndex=0,
	}
	fixture:setFilterData(filterData)
	-- clean
	filterData = {}
	fixture = nil
	shape = nil
end
