TiledLevels = Core.class(Sprite)

function TiledLevels:init(tmpath, xtiny, xbworld, xlayers)
	local myformat = TextureBase.RGBA4444 -- perfs? XXX
	local tm = require(tmpath) -- eg.: "tiled/test" without ".lua" extension + exclude from execution!
	local tsimgpath -- "tiled/", Tiled root path to images
	if g_currlevel == 1 then tsimgpath = "tiled/levels/" -- level01
	elseif g_currlevel == 2 then tsimgpath = "tiled/levels/" -- level02
	-- ...
	end
	-- _______ _____ _      ______  _____ ______ _______ 
	--|__   __|_   _| |    |  ____|/ ____|  ____|__   __|
	--   | |    | | | |    | |__  | (___ | |__     | |   
	--   | |    | | | |    |  __|  \___ \|  __|    | |   
	--   | |   _| |_| |____| |____ ____) | |____   | |   
	--   |_|  |_____|______|______|_____/|______|  |_|   
	-- this is the classic "Tileset"
	for i = 1, #tm.tilesets do
		local tileset = tm.tilesets[i]
		-- add extra values (variables) to a tm.tilesets[i] table
		if tileset.image then -- only tileset tilemap layers
			tileset.numcols = math.floor(
				(tileset.imagewidth-tileset.margin+tileset.spacing)/
				(tileset.tilewidth+tileset.spacing)
			)
			tileset.numrows = math.floor(
				(tileset.imageheight-tileset.margin+tileset.spacing)/
				(tileset.tileheight+tileset.spacing)
			)
			tileset.lastgid = tileset.firstgid+(tileset.numcols*tileset.numrows)-1
			tileset.texture = Texture.new(tsimgpath..tileset.image, false,
				{ format=myformat, extend=false, } -- extend=false, true
			)
		end
	end
	-- classic "Tileset" function
	local function gid2tileset(tm, gid)
		for i = 1, #tm.tilesets do
			local tileset = tm.tilesets[i]
			if tileset.image then -- only valid tileset layers
				if tileset.firstgid <= gid and gid <= tileset.lastgid then
					return tileset
				end
			end
		end
	end
	-- _______ _____ _      ______  _____ ______ _______ 
	--|__   __|_   _| |    |  ____|/ ____|  ____|__   __|
	--   | |    | | | |    | |__  | (___ | |__     | |   
	--   | |    | | | |    |  __|  \___ \|  __|    | |   
	--   | |   _| |_| |____| |____ ____) | |____   | |   
	--   |_|  |_____|______|______|_____/|______|  |_|   
	-- _____ __  __          _____ ______  _____ 
	--|_   _|  \/  |   /\   / ____|  ____|/ ____|
	--  | | | \  / |  /  \ | |  __| |__  | (___  
	--  | | | |\/| | / /\ \| | |_ |  __|  \___ \ 
	-- _| |_| |  | |/ ____ \ |__| | |____ ____) |
	--|_____|_|  |_/_/    \_\_____|______|_____/ 
	-- this one parses individual images "Collection of Images"
	local tilesetimages = {} -- table holding all the tileset images info (path, width, height)
	for i = 1, #tm.tilesets do
		local tileset = tm.tilesets[i]
		if not tileset.image then -- filter out tileset tilemap layers, only tileset images
			local tiles = tileset.tiles
			for j = 1, #tiles do
				-- populate the tilesetimages table based on the tile gid and id
				-- note: you may have to adjust the path (tsimgpath) to point to the image folder
				tilesetimages[tileset.firstgid + tiles[j].id] = {
					path=tsimgpath..tiles[j].image,
					width=tiles[j].width,
					height=tiles[j].height,
				}
			end
		end
	end
--[[
	-- this function is if you don't want to pack your Tiled images even though you should!
	local function parseImage(xobject, xlayer)
		local tex = Texture.new(tilesetimages[xobject.gid].path, false,
			{ format=myformat , extend=false, } -- extend=false, true
		)
		local bitmap = Bitmap.new(tex)
		bitmap:setAnchorPoint(0, 1) -- because I always forget to modify Tiled objects alignment
		-- supports Tiled image scaling
		local scalex, scaley = xobject.width/tex:getWidth(), xobject.height/tex:getHeight()
		bitmap:setScale(scalex, scaley)
		bitmap:setRotation(xobject.rotation)
		bitmap:setPosition(xobject.x, xobject.y)
		xlayer:addChild(bitmap)
	end
]]
	-- pack all the images for perfs (TexturePack)
	local tpt = {} -- texture pack table
	for i = 1, #tm.layers do
		local layer = tm.layers[i]
		if layer.name:match("bg_deco_images") or layer.name:match("fg_deco_images") then
			for i = 1, #layer.objects do
--				print("path", tilesetimages[layer.objects[i].gid].path)
				tpt[#tpt+1] = tilesetimages[layer.objects[i].gid].path
			end
		end
	end
	local tp = TexturePack.new(tpt, nil, nil, { format=myformat, } )
	-- tileset images function
	local function parseImage(xobject, xlayer)
		local bitmap = Bitmap.new(tp:getTextureRegion(tilesetimages[xobject.gid].path))
		bitmap:setAnchorPoint(0, 1) -- because I always forget to modify Tiled objects alignment
		-- supports Tiled image scaling
		local scalex, scaley = xobject.width/bitmap:getWidth(), xobject.height/bitmap:getHeight()
		bitmap:setScale(scalex, scaley)
		bitmap:setRotation(xobject.rotation)
		bitmap:setPosition(xobject.x, xobject.y)
		xlayer:addChild(bitmap)
	end
	-- ____  _    _ _____ _      _____    _      ________      ________ _      
	--|  _ \| |  | |_   _| |    |  __ \  | |    |  ____\ \    / /  ____| |     
	--| |_) | |  | | | | | |    | |  | | | |    | |__   \ \  / /| |__  | |     
	--|  _ <| |  | | | | | |    | |  | | | |    |  __|   \ \/ / |  __| | |     
	--| |_) | |__| |_| |_| |____| |__| | | |____| |____   \  /  | |____| |____ 
	--|____/ \____/|_____|______|_____/  |______|______|   \/   |______|______|
	for i = 1, #tm.layers do
		local layer = tm.layers[i]
		local tilemaps = {}
		local group -- group = Sprite.new()
		-- _______ _____ _      ______ _           __     ________ _____  
		--|__   __|_   _| |    |  ____| |        /\\ \   / /  ____|  __ \ 
		--   | |    | | | |    | |__  | |       /  \\ \_/ /| |__  | |__) |
		--   | |    | | | |    |  __| | |      / /\ \\   / |  __| |  _  / 
		--   | |   _| |_| |____| |____| |____ / ____ \| |  | |____| | \ \ 
		--   |_|  |_____|______|______|______/_/    \_\_|  |______|_|  \_\
		-- this is the classic "Tileset" tile layers
		-- background = bg, foreground = fg
		if layer.type == "tilelayer" and (layer.name:match("bg") or layer.name:match("fg")) then
			if layer.name:match("bg") then group = xlayers["bg"]
			else group = xlayers["fg"]
			end
			for y = 1, layer.height do
				for x = 1, layer.width do
					local index = x + (y - 1) * layer.width
					local gid = layer.data[index]
					local gidtileset = gid2tileset(tm, gid)
					if gidtileset then
						local tilemap
						if tilemaps[gidtileset] then
							tilemap = tilemaps[gidtileset]
						else
							tilemap = TileMap.new(
								layer.width, layer.height,
								gidtileset.texture, gidtileset.tilewidth, gidtileset.tileheight,
								gidtileset.spacing, gidtileset.spacing,
								gidtileset.margin, gidtileset.margin,
								tm.tilewidth, tm.tileheight
							)
							tilemaps[gidtileset] = tilemap
							group:addChild(tilemap)
						end
						local tx = (gid - gidtileset.firstgid) % gidtileset.numcols + 1
						local ty = math.floor((gid - gidtileset.firstgid) / gidtileset.numcols) + 1
						tilemap:setTile(x, y, tx, ty)
					end
				end
			end
			group:setAlpha(layer.opacity)
		--  ____  ____       _ ______ _____ _______ _           __     ________ _____  
		-- / __ \|  _ \     | |  ____/ ____|__   __| |        /\\ \   / /  ____|  __ \ 
		--| |  | | |_) |    | | |__ | |       | |  | |       /  \\ \_/ /| |__  | |__) |
		--| |  | |  _ < _   | |  __|| |       | |  | |      / /\ \\   / |  __| |  _  / 
		--| |__| | |_) | |__| | |___| |____   | |  | |____ / ____ \| |  | |____| | \ \ 
		-- \____/|____/ \____/|______\_____|  |_|  |______/_/    \_\_|  |______|_|  \_\
		-- objects layers can be for decoration (images and shapes) and physics (Bump)
		elseif layer.type == "objectgroup" then
			local o
			local myshape, mytable
			local levelsetup = {}
			--     _                  _                           
			--    | |                | |                          
			--  __| | ___  ___ ___   | | __ _ _   _  ___ _ __ ___ 
			-- / _` |/ _ \/ __/ _ \  | |/ _` | | | |/ _ \ '__/ __|
			--| (_| |  __/ (_| (_) | | | (_| | |_| |  __/ |  \__ \
			-- \__,_|\___|\___\___/  |_|\__,_|\__, |\___|_|  |___/
			--                                 __/ |              
			--                                |___/               
			if layer.name:match("bg_deco_images") then
				for i = 1, #layer.objects do
					parseImage(layer.objects[i], xlayers["bg"])
				end
			elseif layer.name:match("fg_deco_images") then
				for i = 1, #layer.objects do
					parseImage(layer.objects[i], xlayers["fg"])
				end
			elseif layer.name:match("bg_deco_shapes") then
				for i = 1, #layer.objects do
					o = layer.objects[i]
					myshape, mytable = nil, nil
					local color = math.random(0xffffff)
					local shapelinecolor = 0xffffff
					if o.shape == "point" then
						shapelinecolor = math.random(0xffffff)
					end
					mytable = {
						shapelinewidth=1, shapelinecolor=shapelinecolor,
						color=color,
					}
					levelsetup = {}
					for k, v in pairs(mytable) do levelsetup[k] = v end
					myshape = self:buildShapes(o, levelsetup)
					myshape:setPosition(o.x, o.y)
					xlayers["bg"]:addChild(myshape)
				end
			elseif layer.name:match("fg_deco_shapes") then
				for i = 1, #layer.objects do
					o = layer.objects[i]
					myshape, mytable = nil, nil
					local color = math.random(0xffffff)
					local shapelinecolor = 0xffffff
					if o.shape == "point" then
						shapelinecolor = math.random(0xffffff)
					end
					mytable = {
						shapelinewidth=1, shapelinecolor=shapelinecolor,
						color=color,
					}
					levelsetup = {}
					for k, v in pairs(mytable) do levelsetup[k] = v end
					myshape = self:buildShapes(o, levelsetup)
					myshape:setPosition(o.x, o.y)
					xlayers["fg"]:addChild(myshape)
				end
			--       _               _            _                           
			--      | |             (_)          | |                          
			-- _ __ | |__  _   _ ___ _  ___ ___  | | __ _ _   _  ___ _ __ ___ 
			--| '_ \| '_ \| | | / __| |/ __/ __| | |/ _` | | | |/ _ \ '__/ __|
			--| |_) | | | | |_| \__ \ | (__\__ \ | | (_| | |_| |  __/ |  \__ \
			--| .__/|_| |_|\__, |___/_|\___|___/ |_|\__,_|\__, |\___|_|  |___/
			--| |           __/ |                          __/ |              
			--|_|          |___/                          |___/               
			-- add a physics body to the shapes (Bump)
			elseif layer.name:match("physics_grounds") then
				for i = 1, #layer.objects do
					o = layer.objects[i]
					o.isfloor = true -- Bump id
					-- physics body
					xbworld:add(o, o.x, o.y, o.width, o.height)
					-- decor (optional)
					if g_currlevel == 1 then
						local texpath = "gfx/textures/wdipagu_2K_Albedo.jpg_0007.png"
						mytable = {
							texpath=texpath, istexpot=true, scalex=1,
						}
						levelsetup = {}
						for k, v in pairs(mytable) do levelsetup[k] = v end
						myshape = self:buildShapes(o, levelsetup)
						myshape:setPosition(o.x, o.y)
						xlayers["bg"]:addChild(myshape)
					end
				end
			--            _                 
			--           | |                
			--  __ _  ___| |_ ___  _ __ ___ 
			-- / _` |/ __| __/ _ \| '__/ __|
			--| (_| | (__| || (_) | |  \__ \
			-- \__,_|\___|\__\___/|_|  |___/
			elseif layer.name == "physics_players" then -- player1
				for i = 1, #layer.objects do
					o = layer.objects[i]
					local opos = vector(o.x, o.y)
					-- EPlayer1:init(xspritelayer, xpos)
					self.player1 = EPlayer1.new(xlayers["actors"], opos)
					xtiny.tworld:addEntity(self.player1)
					-- physics body
					xbworld:add(
						self.player1,
						self.player1.pos.x, self.player1.pos.y,
						self.player1.collbox.w, self.player1.collbox.h
					)
				end
			end
			-- some cleaning?
			o = nil
			myshape, mytable = nil, nil
			levelsetup = {}
		end
	end
end

-- deco shapes
function TiledLevels:buildShapes(xobject, xlevelsetup)
	local myshape -- Tiled shapes: ellipse, point, polygon, polyline, rectangle, text
	local tablebase = {}
	if xobject.shape == "ellipse" then
		tablebase = {
			x=xobject.x, y=xobject.y,
			w=xobject.width, h=xobject.height,
			rotation=xobject.rotation,
		}
		for k, v in pairs(xlevelsetup) do tablebase[k] = v end
		myshape = Tiled_Shape_Ellipse.new(tablebase)
	elseif xobject.shape == "point" then
		tablebase = {
			x=xobject.x, y=xobject.y,
			rotation=xobject.rotation,
		}
		for k, v in pairs(xlevelsetup) do tablebase[k] = v end
		myshape = Tiled_Shape_Point.new(tablebase)
	elseif xobject.shape == "polygon" then
		tablebase = {
			x=xobject.x, y=xobject.y,
			coords=xobject.polygon,
			rotation=xobject.rotation,
		}
		for k, v in pairs(xlevelsetup) do tablebase[k] = v end
		myshape = Tiled_Shape_Polygon.new(tablebase)
	elseif xobject.shape == "polyline" then -- lines
		tablebase = {
			x=xobject.x, y=xobject.y,
			coords=xobject.polyline,
			rotation=xobject.rotation,
		}
		for k, v in pairs(xlevelsetup) do tablebase[k] = v end
		myshape = Tiled_Shape_Polyline.new(tablebase)
	elseif xobject.shape == "rectangle" then
		tablebase = {
			x=xobject.x, y=xobject.y,
			w=xobject.width, h=xobject.height,
			rotation=xobject.rotation,
		}
		for k, v in pairs(xlevelsetup) do tablebase[k] = v end
		myshape = Tiled_Shape_Rectangle.new(tablebase)
	elseif xobject.shape == "text" then
		tablebase = {
			x=xobject.x, y=xobject.y,
			text=xobject.text,
			w=xobject.width, h=xobject.height,
			rotation=xobject.rotation,
		}
		for k, v in pairs(xlevelsetup) do tablebase[k] = v end
		myshape = Tiled_Shape_Text.new(tablebase)
	else
		print("*** CANNOT PROCESS THIS SHAPE! ***", xobject.shape, xobject.name)
		return
	end

	return myshape
end
