SCollision = Core.class()

function SCollision:init(xtiny, xbworld) -- tiny function
	xtiny.processingSystem(self) -- called once on init and every update
	self.bworld = xbworld
end

function SCollision:filter(ent) -- tiny function
	return ent.collbox and ent.body
end

function SCollision:onAdd(ent) -- tiny function
end

function SCollision:onRemove(ent) -- tiny function
end

function SCollision:process(ent, dt) -- tiny function
	-- physics flags
	ent.isfloorcontacts = false
	--  _____ ____  _      _      _____  _____ _____ ____  _   _ 
	-- / ____/ __ \| |    | |    |_   _|/ ____|_   _/ __ \| \ | |
	--| |   | |  | | |    | |      | | | (___   | || |  | |  \| |
	--| |   | |  | | |    | |      | |  \___ \  | || |  | | . ` |
	--| |___| |__| | |____| |____ _| |_ ____) |_| || |__| | |\  |
	-- \_____\____/|______|______|_____|_____/|_____\____/|_| \_|
	-- ______ _____ _   _______ ______ _____  
	--|  ____|_   _| | |__   __|  ____|  __ \ 
	--| |__    | | | |    | |  | |__  | |__) |
	--|  __|   | | | |    | |  |  __| |  _  / 
	--| |     _| |_| |____| |  | |____| | \ \ 
	--|_|    |_____|______|_|  |______|_|  \_\
	local function collisionfilter(item, other) -- "touch", "cross", "slide", "bounce"
		if other.isfloor then
			return "slide"
		end
		return "cross"
	end
	--  _____ ____  _    _ __  __ _____  
	-- / ____|  _ \| |  | |  \/  |  __ \ 
	--| |    | |_) | |  | | \  / | |__) |
	--| |    |  _ <| |  | | |\/| |  ___/ 
	--| |____| |_) | |__| | |  | | |     
	-- \_____|____/ \____/|_|  |_|_|     
	local goalx = ent.pos.x + ent.body.vx * dt
	local goaly = ent.pos.y + ent.body.vy * dt
	local nextx, nexty, collisions, len = self.bworld:move(ent, goalx, goaly, collisionfilter)
	--  _____ ____  _      _      _____  _____ _____ ____  _   _  _____ 
	-- / ____/ __ \| |    | |    |_   _|/ ____|_   _/ __ \| \ | |/ ____|
	--| |   | |  | | |    | |      | | | (___   | || |  | |  \| | (___  
	--| |   | |  | | |    | |      | |  \___ \  | || |  | | . ` |\___ \ 
	--| |___| |__| | |____| |____ _| |_ ____) |_| || |__| | |\  |____) |
	-- \_____\____/|______|______|_____|_____/|_____\____/|_| \_|_____/ 
	for i = 1, len do
		local item = collisions[i].item
		local other = collisions[i].other
		local normal = collisions[i].normal
		-- COLLISION FROM TOP
		if normal.y == -1 then
			if other.isfloor then
				item.body.vy = 0 -- reset velocity y (don't accumulate gravity)
				item.isfloorcontacts = true
				item.body.currjumpcount = item.body.jumpcount
				item.body.currcoyotetimer = item.body.coyotetimer
			end
		end
	end
	--  _____ _____       __      _______ _________     __
	-- / ____|  __ \     /\ \    / /_   _|__   __\ \   / /
	--| |  __| |__) |   /  \ \  / /  | |    | |   \ \_/ / 
	--| | |_ |  _  /   / /\ \ \/ /   | |    | |    \   /  
	--| |__| | | \ \  / ____ \  /   _| |_   | |     | |   
	-- \_____|_|  \_\/_/    \_\/   |_____|  |_|     |_|   
	if ent.body.vy < 0 then -- going up
		ent.body.vy += 3*8 * ent.body.currmass -- gravity, magik XXX
	else -- going down, increase gravity
		ent.body.vy += 5*8 * ent.body.currmass -- 5*8, gravity, magik XXX
		if ent.body.vy > 600 then -- 500, cap falling speed
			ent.body.vy = 600
		end
	end
	--  _____  _    ___     _______ _____ _____  _____ 
	-- |  __ \| |  | \ \   / / ____|_   _/ ____|/ ____|
	-- | |__) | |__| |\ \_/ / (___   | || |    | (___  
	-- |  ___/|  __  | \   / \___ \  | || |     \___ \ 
	-- | |    | |  | |  | |  ____) |_| || |____ ____) |
	-- |_|    |_|  |_|  |_| |_____/|_____\_____|_____/ 
	if ent.body.currinputbuffer > 0 then -- floor input buffer
		ent.body.currinputbuffer -= 1
	end
	if ent.body.currcoyotetimer > 0 then -- coyote time
		ent.body.currcoyotetimer -= 1
	end
	if ent.body.currdashtimer > 0 then -- dash
		ent.body.currdashtimer -= 1
	end
	if ent.body.currdashcooldown > 0 then -- dash cooldown
		ent.body.currdashcooldown -= 1
	end
	-- IS ON FLOOR
	if ent.isfloorcontacts then
		if ent.isleft and not ent.isright then -- LEFT
			ent.flip = -1
			if ent.body.currdashtimer > 0 then 
				ent.body.vx -= ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.vx = -ent.body.currspeed
			end
		elseif ent.isright and not ent.isleft then -- RIGHT
			ent.flip = 1
			if ent.body.currdashtimer > 0 then 
				ent.body.vx += ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.vx = ent.body.currspeed
			end
		else
			ent.body.vx *= 0.75 -- deceleration
			if (-ent.body.vx<>ent.body.vx) < 0.001 then ent.body.vx = 0 end
		end
		if ent.body.currinputbuffer > 0 and not ent.isdown and not ent.wasup then -- UP
			ent.body.vy = -ent.body.currupspeed
			ent.wasup = true
			ent.body.currinputbuffer = 0 -- prevents double jump when releasing up key
		elseif ent.isdown and not ent.isup then -- DOWN
		end
	-- IS IN THE AIR
	else
		if ent.isleft and not ent.isright then -- LEFT
			ent.flip = -1
			if ent.body.currdashtimer > 0 then 
				ent.body.vx -= ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.vx = -ent.body.currspeed
			end
		elseif ent.isright and not ent.isleft then -- RIGHT
			ent.flip = 1
			if ent.body.currdashtimer > 0 then 
				ent.body.vx += ent.body.currspeed*ent.body.dashmultiplier
			else
				ent.body.vx = ent.body.currspeed
			end
		else
			ent.body.vx *= 0.75 -- deceleration
			if -ent.body.vx<>ent.body.vx < 0.001 then ent.body.vx = 0 end
		end
		-- double jump
		if ent.isup and ent.body.currjumpcount >= 1 then -- UP
			ent.isup = false
			ent.wasup = false
			ent.body.currjumpcount -= 1
			ent.body.vy = -ent.body.currupspeed
		-- input buffer
		elseif ent.body.currinputbuffer > 0 and not ent.isdown and not ent.wasup then -- UP
			if ent.body.currcoyotetimer > 0 then
				ent.body.currcoyotetimer = 0
				ent.body.vy = -ent.body.currupspeed
			end
		elseif ent.isdown and not ent.isup and not ent.wasdown then -- DOWN
			ent.wasdown = true
		end
	end
	-- move & flip
	ent.pos = vector(nextx, nexty)
	ent.sprite:setPosition(ent.pos + vector(ent.collbox.w/2, -ent.h/2+ent.collbox.h))
end
