LevelX = Core.class(Sprite)

function LevelX:init()
	application:setBackgroundColor(0x55aaff)
	-- _           __     ________ _____   _____ 
	--| |        /\\ \   / /  ____|  __ \ / ____|
	--| |       /  \\ \_/ /| |__  | |__) | (___  
	--| |      / /\ \\   / |  __| |  _  / \___ \ 
	--| |____ / ____ \| |  | |____| | \ \ ____) |
	--|______/_/    \_\_|  |______|_|  \_\_____/ 
	local layers = {}
	layers["main"] = Sprite.new() -- one Sprite to hold them all
	layers["bg"] = Sprite.new() -- bg layer
	layers["actors"] = Sprite.new() -- actors layer
	layers["fg"] = Sprite.new() -- fg layer
	-- _      ________      ________ _       _____ 
	--| |    |  ____\ \    / /  ____| |     / ____|
	--| |    | |__   \ \  / /| |__  | |    | (___  
	--| |    |  __|   \ \/ / |  __| | |     \___ \ 
	--| |____| |____   \  /  | |____| |____ ____) |
	--|______|______|   \/   |______|______|_____/ 
	self.tiledlevels = {}
	self.tiledlevels[1] = "tiled/levels/level01" -- lua file without extension
	self.tiledlevels[2] = "tiled/levels/level02" -- lua file without extension
	-- ...
	-- here we build the level using Tiled
	TiledLevels.new(self.tiledlevels[g_currlevel], layers)
	--  _____          __  __ ______ _____            
	-- / ____|   /\   |  \/  |  ____|  __ \     /\    
	--| |       /  \  | \  / | |__  | |__) |   /  \   
	--| |      / /\ \ | |\/| |  __| |  _  /   / /\ \  
	--| |____ / ____ \| |  | | |____| | \ \  / ____ \ 
	-- \_____/_/    \_\_|  |_|______|_|  \_\/_/    \_\
	-- navigate de maps with the arrow keys
	self.camera = Sprite.new()
	self.camera.x = 4*64
	self.camera.y = 8*64
	local zoom = 1.5
	self.camera:setScale(zoom)
	--  ____  _____  _____  ______ _____  
	-- / __ \|  __ \|  __ \|  ____|  __ \ 
	--| |  | | |__) | |  | | |__  | |__) |
	--| |  | |  _  /| |  | |  __| |  _  / 
	--| |__| | | \ \| |__| | |____| | \ \ 
	-- \____/|_|  \_\_____/|______|_|  \_\
	layers["main"]:addChild(layers["bg"])
	layers["main"]:addChild(layers["actors"])
	layers["main"]:addChild(layers["fg"])
	self.camera:addChild(layers["main"])
	self:addChild(self.camera)
	-- _      _____  _____ _______ ______ _   _ ______ _____   _____ 
	--| |    |_   _|/ ____|__   __|  ____| \ | |  ____|  __ \ / ____|
	--| |      | | | (___    | |  | |__  |  \| | |__  | |__) | (___  
	--| |      | |  \___ \   | |  |  __| | . ` |  __| |  _  / \___ \ 
	--| |____ _| |_ ____) |  | |  | |____| |\  | |____| | \ \ ____) |
	--|______|_____|_____/   |_|  |______|_| \_|______|_|  \_\_____/ 
	self:addEventListener(Event.ENTER_FRAME, self.onEnterFrame, self)
	self:myKeysPressed() -- keys handler
end

-- game loop
function LevelX:onEnterFrame(e)
	local dt = e.deltaTime
	-- camera
	if self.isup then self.camera.y -= 200*dt
	elseif self.isdown then self.camera.y += 200*dt
	end
	if self.isleft then self.camera.x -= 200*dt
	elseif self.isright then self.camera.x += 200*dt
	end
	self.camera:set("anchorX", self.camera.x-myappwidth/2/self.camera:getScale())
	self.camera:set("anchorY", self.camera.y-myappheight/1.8/self.camera:getScale())
end

-- keys handler
function LevelX:myKeysPressed()
	self:addEventListener(Event.KEY_DOWN, function(e) -- KEY_DOWN
		-- camera control
		if e.keyCode == KeyCode.UP then self.isup = true
		elseif e.keyCode == KeyCode.DOWN then self.isdown = true
		elseif e.keyCode == KeyCode.LEFT then self.isleft = true
		elseif e.keyCode == KeyCode.RIGHT then self.isright = true
		end
		-- exit
		if e.keyCode == KeyCode.ESC or e.keyCode == KeyCode.BACK then
			if not application:isPlayerMode() then application:exit() end
		end
		-- full screen
		local modifier = application:getKeyboardModifiers()
		local alt = (modifier & KeyCode.MODIFIER_ALT) > 0
		if (not alt and e.keyCode == KeyCode.ENTER) then -- nothing here!
		elseif alt and e.keyCode == KeyCode.ENTER then -- SWITCH FULLSCREEN
			ismyappfullscreen = not ismyappfullscreen
			application:setFullScreen(ismyappfullscreen)
		end
	end)
	self:addEventListener(Event.KEY_UP, function(e) -- KEY_UP
		-- camera control
		if e.keyCode == KeyCode.UP then self.isup = false
		elseif e.keyCode == KeyCode.DOWN then self.isdown = false
		elseif e.keyCode == KeyCode.LEFT then self.isleft = false
		elseif e.keyCode == KeyCode.RIGHT then self.isright = false
		end
--		print(self.camera.x, self.camera.y)
	end)
end
